define([
    'backbone',
    'modules/page/popup/warning-popup-view',
    'text!modules/page/popup/external-nav.html',
],
function (Backbone, WarningPopupView, template) {
    'use strict';

    return WarningPopupView.extend({
        id: 'external-nav',
        template: template,
        model: new Backbone.Model({href: ''}),
        continue: function() {
            this.openUrl();
        },
        openUrl: function() {
            window.open(this.model.get('href'), '_blank').focus();
        },
    });
});
